/*
 * 
 * Datei:   OutputFileExistsException.java
 * 
 * ---------------------------------
 * 
 * Datum:           $Date: 2004/05/14 09:06:10 $
 * Autor:           Simon Tiffert 
 * Prfungsnummer:  40
 * Firma:           T-Systems
 * eMail-Adresse:   simon.tiffert@t-systems.com
 * Version:         $Revision: 1.3 $
 * 
 * ---------------------------------
 * 
 */
package main.tools.file;

import java.io.IOException;

/**
 * Diese Exception wird geworfen, wenn die Ausgabedatei schon existiert 
 * und nicht berschrieben werden soll
 * 
 * @version $Revision: 1.3 $
 * @author Simon Tiffert
 */
public class OutputFileExistsException extends IOException
{
  /**
   * Es wird ein Konstruktor aufgerufen, der den Namen der Ausgabedatei
   * bergeben bekommt
   * 
   * @param dateiname Dateiname der Ausgabedatei
   */
  public OutputFileExistsException(String dateiname)
  {
    super(dateiname);
  }
}
