/*
 * 
 * Datei:   OutputFile.java
 * 
 * ---------------------------------
 * 
 * Datum:           $Date: 2004/05/13 10:15:32 $
 * Autor:           Simon Tiffert 
 * Prfungsnummer:  40
 * Firma:           T-Systems
 * eMail-Adresse:   simon.tiffert@t-systems.com
 * Version:         $Revision: 1.7 $
 * 
 * ---------------------------------
 * 
 */

package main.tools.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import main.Main;

/**
 * Diese Klasse bekommt den Namen einer Eingabedatei bergeben und 
 * erzeugt daraus eine Ausgabedatei.
 * Auerdem kann sie diese Datei zum Schreiben ffnen.
 * 
 * @version $Revision: 1.7 $
 * @author Simon Tiffert
 */
public class OutputFile extends File
{
  /**
   * Konstruktor, der den Konstruktor der Superklasse mit dem in dieser
   * Klasse erstellten Ausgabedateinamen aufruft.
   * 
   * @param pathname Pfadname
   * @param endung Endung
   */
  public OutputFile(String pathname, String endung)
  {
    super(setNameAusgabeDatei(pathname, endung));
  }

  /**
   * Der Name der Ausgabedatei wird gebildet, in dem der Text nach dem 
   * letzten Punkt, durch die bergebene Endung ersetzt wird. 
   * 
   * @param eingabeDateiName Name der Eingabedatei
   * @param endung Neue Endung
   * @return Name der Ausgabedatei
   */
  private static String setNameAusgabeDatei(
    String eingabeDateiName,
    String endung)
  {
    int index;

    // der Index des letzten Punktes wird gesucht
    index = eingabeDateiName.lastIndexOf(".");

    // ist kein Punkt enthalten
    if (index < 0)
    {
      // setze den Index auf das Ende des Eingabenamens
      index = eingabeDateiName.length();
    }

    // fge die neue Endung am Index ein
    return eingabeDateiName.substring(0, index) + endung;
  }

  /**
   * Die Funktion gibt einen BufferedWriter auf das File Objekt zurck.
   * Dabei wird getestet, ob eine vorhandene Datei berschrieben werden
   * darf und entsprechend reagiert.
   * 
   * @return BufferedWriter fr Ausgabedatei
   * @throws IOException
   */
  public BufferedWriter getAusgabeDatei()
    throws IOException, OutputFileExistsException
  {
    // Wenn die Datei nicht berschrieben werden soll
    if (!Main.overwrite)
    {
      // und die Datei existiert, werfe eine Exception
      if (this.exists())
      {
        throw new OutputFileExistsException(this.getName());
      }
    }

    // ansonsten erstelle einen BufferedWriter auf die 
    // Ausgabedatei
    BufferedWriter bw = new BufferedWriter(new FileWriter(this));
    
    // gib diesen BufferedWriter zurck
    return bw;
  }

}
