/*
 * 
 * Datei:   MyLineNumberReader.java
 * 
 * ---------------------------------
 * 
 * Datum:           $Date: 2004/05/13 08:48:03 $
 * Autor:           Simon Tiffert 
 * Prfungsnummer:  40
 * Firma:           T-Systems
 * eMail-Adresse:   simon.tiffert@t-systems.com
 * Version:         $Revision: 1.4 $
 * 
 * ---------------------------------
 * 
 */
package main.tools.eingabe;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;

/**
 * Klasse, welche Zeilenendkommentar berliest
 * 
 * @version $Revision: 1.4 $
 * @author Simon Tiffert
 */
public class MyLineNumberReader extends LineNumberReader
{
  //Kommentar, der berlesen werden soll
  private String kommentar = "";

  /**
   * Der Kommentar, der berlesen werden soll, wird definiert und 
   * der Standardkonstruktor der Superklasse wird aufgerufen.
   * 
   * @param reader
   * @param kommentar
   */
  public MyLineNumberReader(Reader reader, String kommentar)
  {
    // Konstruktor der Superklasse und setzen des Kommentars
    super(reader);
    this.kommentar = kommentar;
  }

  /**
   * Die Funktionalitt der Supermethode wird
   * beibehalten, allerdings werden Zeilen, die mit
   * einem oben definierten Kommentar beginnen, nicht mit 
   * ausgegeben.
   * 
   * @see java.io.BufferedReader#readLine()
   */
  public String readLine() throws IOException
  {
    // Der Ausgabestring wird mit der ersten Zeile vorbesetzt, aus der
    // Kommentar und Zwischenraumzeichen entfernt wurden
    String ausgabe = stripLine(super.readLine());

    // wenn die Ausgabe nicht null ist
    if (ausgabe != null)
    {
      // solange nur noch ein leerer String brig bleibt, lese
      // die nchste Zeile und entferne Kommentar und weitere
      // Zwischenraumzeichen
      while (ausgabe.length() == 0)
      {
        ausgabe = stripLine(super.readLine());

        // wenn die Zeile null ist, so gebe dies zurck
        if (ausgabe == null)
        {
          return ausgabe;
        }
      }
    }

    // gib die berarbeitete Zeile zurck
    return ausgabe;
  }

  /**
   * Diese Funktion entfernt Zeilenendkommentar
   * 
   * @param zeile Die Zeile, die bearbeitet werden soll
   * @return Die Zeile, in der kein Kommentar mehr steht
   */
  private String stripLine(String zeile)
  {
    // wenn die Zeile ungleich null ist, bearbeite sie
    if (zeile != null)
    {
      // wenn Kommentar vorhanden ist, schneide diesen ab
      if (zeile.indexOf(kommentar) >= 0)
      {
        // entferne unntige Leerzeichen an Anfang und Ende
        return zeile.substring(0, zeile.indexOf(kommentar)).trim();
      }
      else
      {
        // entferne unntige Leerzeichen an Anfang und Ende
        return zeile.trim();
      }
    }

    // gib die Zeile zurck
    return zeile;
  }
}
