/*
 * Decompiled with CFR 0.152.
 */
package main.verarbeitung;

import main.verarbeitung.Matrix;
import main.verarbeitung.MatrixNotInitialisedException;

public class Verarbeitung {
    private Matrix matrix;

    public Verarbeitung(Matrix matrix) throws MatrixNotInitialisedException {
        this.matrix = matrix;
        if (!matrix.isInitialisiert()) {
            throw new MatrixNotInitialisedException();
        }
        if (this.roesselSprung(1, matrix.getStartpunkt().getY(), matrix.getStartpunkt().getX())) {
            matrix.setWegGefunden();
        }
    }

    private boolean roesselSprung(int zaehler, int y, int x) {
        if (!this.matrix.isInMatrix(y, x)) {
            return false;
        }
        if (this.matrix.getWert(y, x) != 0) {
            return false;
        }
        this.matrix.setWert(y, x, zaehler);
        if (zaehler == this.matrix.getFeldAnzahl()) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y - 2, x + 1)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y - 1, x + 2)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y + 1, x + 2)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y + 2, x + 1)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y + 2, x - 1)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y + 1, x - 2)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y - 1, x - 2)) {
            return true;
        }
        if (this.roesselSprung(zaehler + 1, y - 2, x - 1)) {
            return true;
        }
        this.matrix.setWert(y, x, 0);
        return false;
    }
}

