/*
 * Decompiled with CFR 0.152.
 */
package main.verarbeitung;

import main.verarbeitung.IsSperrfeldException;
import main.verarbeitung.IsStartpunktException;
import main.verarbeitung.OutOfMatrixException;
import main.verarbeitung.Punkt;
import main.verarbeitung.ReDefinedStartpunktException;
import main.verarbeitung.WrongDimensionException;

public class Matrix {
    private boolean isInitialisiert = false;
    private int[][] matrix;
    private int sperrFeldAnzahl = 0;
    private Punkt startpunkt = null;
    private boolean wegGefunden = false;

    public int getFeldAnzahl() {
        return this.getXDimension() * this.getYDimension() - this.sperrFeldAnzahl;
    }

    public Punkt getStartpunkt() {
        return this.startpunkt;
    }

    public int getWert(int y, int x) {
        return this.matrix[y][x];
    }

    public int getXDimension() {
        return this.matrix[0].length;
    }

    public int getYDimension() {
        return this.matrix.length;
    }

    public boolean isInitialisiert() {
        return this.isInitialisiert;
    }

    public boolean isInMatrix(int y, int x) {
        if (y < 0) {
            return false;
        }
        if (x < 0) {
            return false;
        }
        if (y >= this.getYDimension()) {
            return false;
        }
        return x < this.getXDimension();
    }

    public boolean isSperrfeld(int y, int x) {
        return this.getWert(y, x) < 0;
    }

    public boolean isStartpunkt(int y, int x) {
        return y == this.startpunkt.getY() && x == this.startpunkt.getX();
    }

    public boolean isWegGefunden() {
        return this.wegGefunden;
    }

    public void setMatrix(int m, int n) throws WrongDimensionException {
        if (m <= 0 || n <= 0 || m > 6 || n > 6) {
            throw new WrongDimensionException();
        }
        this.matrix = new int[m][n];
    }

    public void setSperrfeld(int y, int x) throws OutOfMatrixException, IsSperrfeldException, IsStartpunktException {
        if (!this.isInMatrix(y, x)) {
            throw new OutOfMatrixException("Sperrfeld X(" + (y + 1) + "," + (x + 1) + ")");
        }
        if (this.isSperrfeld(y, x)) {
            throw new IsSperrfeldException("(" + (y + 1) + "," + (x + 1) + ")");
        }
        if (this.isStartpunkt(y, x)) {
            throw new IsStartpunktException("(" + (y + 1) + "," + (x + 1) + ")");
        }
        ++this.sperrFeldAnzahl;
        this.setWert(y, x, -1);
    }

    public void setStartpunkt(int y, int x) throws OutOfMatrixException, ReDefinedStartpunktException {
        if (!this.isInMatrix(y, x)) {
            throw new OutOfMatrixException("Startpunkt S(" + (y + 1) + "," + (x + 1) + ")");
        }
        if (this.startpunkt != null) {
            throw new ReDefinedStartpunktException();
        }
        this.isInitialisiert = true;
        this.startpunkt = new Punkt(y, x);
    }

    protected void setWegGefunden() {
        this.wegGefunden = true;
    }

    protected void setWert(int y, int x, int wert) {
        this.matrix[y][x] = wert;
    }
}

