/*
 * Decompiled with CFR 0.152.
 */
package main.eingabe;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import main.eingabe.TooFewCharactersException;
import main.eingabe.TooFewSperrfelderException;
import main.eingabe.UnexpectedCharacterException;
import main.eingabe.UnexpectedLineException;
import main.eingabe.UnknownCharacterException;
import main.tools.eingabe.MyLineNumberReader;
import main.verarbeitung.IsSperrfeldException;
import main.verarbeitung.IsStartpunktException;
import main.verarbeitung.Matrix;
import main.verarbeitung.WrongDimensionException;

public class Eingabe {
    private Matrix matrix;

    public Eingabe(Matrix matrix, String dateiName) throws UnexpectedCharacterException, UnexpectedLineException, UnknownCharacterException, TooFewCharactersException, TooFewSperrfelderException, FileNotFoundException, IOException, IsSperrfeldException, IsStartpunktException, WrongDimensionException {
        this.matrix = matrix;
        File file = new File(dateiName);
        this.leseDaten(new FileReader(file));
    }

    private void leseDaten(Reader stream) throws UnexpectedCharacterException, UnexpectedLineException, UnknownCharacterException, IOException, TooFewCharactersException, TooFewSperrfelderException, IsSperrfeldException, IsStartpunktException, WrongDimensionException {
        String zeile = "";
        int gesperrteFelder = 0;
        int y = 0;
        int x = 0;
        MyLineNumberReader lineNumber = new MyLineNumberReader(stream, "**");
        zeile = ((LineNumberReader)lineNumber).readLine();
        if (zeile == null) {
            throw new TooFewCharactersException("" + lineNumber.getLineNumber());
        }
        StringTokenizer st = new StringTokenizer(zeile);
        try {
            y = Integer.parseInt(st.nextToken());
            x = Integer.parseInt(st.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new TooFewCharactersException("" + lineNumber.getLineNumber());
        }
        catch (Exception e) {
            throw new UnknownCharacterException("" + lineNumber.getLineNumber());
        }
        this.matrix.setMatrix(y, x);
        if (st.hasMoreTokens()) {
            throw new UnexpectedCharacterException("" + lineNumber.getLineNumber());
        }
        zeile = ((LineNumberReader)lineNumber).readLine();
        if (zeile == null) {
            throw new TooFewCharactersException("" + lineNumber.getLineNumber());
        }
        st = new StringTokenizer(zeile);
        try {
            y = Integer.parseInt(st.nextToken()) - 1;
            x = Integer.parseInt(st.nextToken()) - 1;
        }
        catch (NoSuchElementException e) {
            throw new TooFewCharactersException("" + lineNumber.getLineNumber());
        }
        catch (Exception e) {
            throw new UnknownCharacterException("" + lineNumber.getLineNumber());
        }
        this.matrix.setStartpunkt(y, x);
        if (st.hasMoreTokens()) {
            throw new UnexpectedCharacterException("" + lineNumber.getLineNumber());
        }
        zeile = ((LineNumberReader)lineNumber).readLine();
        if (zeile != null) {
            try {
                gesperrteFelder = Integer.parseInt(zeile);
            }
            catch (Exception e) {
                throw new UnknownCharacterException("" + lineNumber.getLineNumber());
            }
            int i = 0;
            while (i < gesperrteFelder) {
                zeile = ((LineNumberReader)lineNumber).readLine();
                if (zeile != null) {
                    st = new StringTokenizer(zeile);
                    try {
                        y = Integer.parseInt(st.nextToken()) - 1;
                        x = Integer.parseInt(st.nextToken()) - 1;
                    }
                    catch (NoSuchElementException e) {
                        throw new TooFewCharactersException("" + lineNumber.getLineNumber());
                    }
                    catch (Exception e) {
                        throw new UnknownCharacterException("" + lineNumber.getLineNumber());
                    }
                    if (st.hasMoreTokens()) {
                        throw new UnexpectedCharacterException("" + lineNumber.getLineNumber());
                    }
                } else {
                    throw new TooFewSperrfelderException();
                }
                this.matrix.setSperrfeld(y, x);
                ++i;
            }
        }
        if (((LineNumberReader)lineNumber).readLine() != null) {
            throw new UnexpectedLineException("" + lineNumber.getLineNumber());
        }
    }
}

