/*
 * Decompiled with CFR 0.152.
 */
package main.ausgabe;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import main.Main;
import main.NoInputException;
import main.WrongParameterException;
import main.eingabe.TooFewCharactersException;
import main.eingabe.TooFewSperrfelderException;
import main.eingabe.UnexpectedCharacterException;
import main.eingabe.UnexpectedLineException;
import main.eingabe.UnknownCharacterException;
import main.tools.file.OutputFileExistsException;
import main.verarbeitung.IsSperrfeldException;
import main.verarbeitung.IsStartpunktException;
import main.verarbeitung.OutOfMatrixException;
import main.verarbeitung.WrongDimensionException;

public class FehlerAusgabe {
    String eingabeDateiName;
    BufferedWriter bw;
    Exception exception;

    public FehlerAusgabe(BufferedWriter bw, Exception exception, String dateiName) {
        this.bw = bw;
        this.exception = exception;
        this.eingabeDateiName = dateiName;
        this.printError();
    }

    private void printError() {
        if (this.exception instanceof UnexpectedCharacterException) {
            this.schreibeFehler("Zuviel Eingaben in Zeile " + this.exception.getMessage());
        } else if (this.exception instanceof UnexpectedLineException) {
            this.schreibeFehler("Es folgen noch Zeichen nach der Eingabe in Zeile " + this.exception.getMessage());
        } else if (this.exception instanceof UnknownCharacterException) {
            this.schreibeFehler("Unbekanntes Zeichen in der Eingabe in Zeile " + this.exception.getMessage());
        } else if (this.exception instanceof TooFewCharactersException) {
            this.schreibeFehler("Zu wenig Zeichen f\u00fcr Eingabe in Zeile " + this.exception.getMessage());
        } else if (this.exception instanceof TooFewSperrfelderException) {
            this.schreibeFehler("Es sind zu wenige Sperrfelder angegeben");
        } else if (this.exception instanceof WrongDimensionException) {
            this.schreibeFehler("Falsche Dimensionsangaben f\u00fcr Matrix");
        } else if (this.exception instanceof OutOfMatrixException) {
            this.schreibeFehler(String.valueOf(this.exception.getMessage()) + " au\u00dferhalb der Matrix definiert");
        } else if (this.exception instanceof IsStartpunktException) {
            this.schreibeFehler("Sperrfeld auf Startpunkt" + this.exception.getMessage() + " definiert");
        } else if (this.exception instanceof IsSperrfeldException) {
            this.schreibeFehler("Sperrfeld " + this.exception.getMessage() + " doppelt definiert");
        } else if (this.exception instanceof FileNotFoundException) {
            System.out.println("Die Eingabedatei wurde nicht gefunden");
        } else if (this.exception instanceof OutputFileExistsException) {
            System.out.println("Die Datei " + this.exception.getMessage() + " existiert schon");
        } else if (this.exception instanceof NoInputException) {
            System.out.println("Es wurde kein Parameter f\u00fcr das Programm \u00fcbergeben.");
            FehlerAusgabe.hilfeAusgabe();
        } else if (this.exception instanceof WrongParameterException) {
            System.out.println(this.exception.getMessage());
            FehlerAusgabe.hilfeAusgabe();
        } else if (this.exception instanceof IOException) {
            this.schreibeFehler("Es ist ein Fehler bei der Ausgabe aufgetreten:" + this.exception.getMessage());
        } else {
            this.schreibeFehler("Es ist ein Fehler aufgetreten: " + this.exception.getMessage());
        }
    }

    private void schreibeFehler(String s) {
        StringBuffer eingabe = new StringBuffer("");
        String lineEnd = System.getProperty("line.separator");
        if (lineEnd == null) {
            lineEnd = "\n";
        }
        String tabulator = "    ";
        try {
            String zeile;
            LineNumberReader line = new LineNumberReader(new FileReader(new File(this.eingabeDateiName)));
            eingabe.append(String.valueOf(lineEnd) + tabulator + "Eingabedaten: " + lineEnd);
            eingabe.append(String.valueOf(tabulator) + "*************" + lineEnd);
            while ((zeile = line.readLine()) != null) {
                String whitespace = "  ";
                if (line.getLineNumber() >= 10) {
                    whitespace = " ";
                }
                eingabe.append(String.valueOf(whitespace) + line.getLineNumber() + ":" + tabulator + zeile + lineEnd);
            }
        }
        catch (Exception line) {
            // empty catch block
        }
        try {
            if (Main.debug) {
                System.out.println(eingabe + lineEnd + lineEnd);
                System.out.println(String.valueOf(tabulator) + s);
            }
            this.bw.write(eingabe + lineEnd + lineEnd);
            this.bw.write(String.valueOf(tabulator) + s);
        }
        catch (Exception e) {
            System.err.println("Die Ausgabedatei konnte nicht beschrieben werden.");
        }
    }

    private static void hilfeAusgabe() {
        System.out.println("Aufruf:\njava -jar programm.jar -d Datei [-h][-debug][-overwrite]\n\n-h         zeigt diese Hilfe an\n-debug     die Fehlerausgabe wird zus\u00e4tzlich auf dem  Bildschirm ausgeben\n-overwrite eine vorhandene Ausgabedatei mit gleichem Namen  wird \u00fcberschrieben\n");
    }
}

