/*
 * Decompiled with CFR 0.152.
 */
package main.ausgabe;

import java.io.BufferedWriter;
import java.io.IOException;
import main.Main;
import main.verarbeitung.Matrix;

public class Ausgabe {
    private Matrix matrix;

    public Ausgabe(Matrix matrix, BufferedWriter bw) throws IOException {
        this.matrix = matrix;
        this.ausgabe(bw, false);
        if (matrix.isWegGefunden()) {
            this.ausgabe(bw, true);
        } else {
            this.keinWegGefundenAusgabe(bw);
        }
    }

    private void keinWegGefundenAusgabe(BufferedWriter bw) throws IOException {
        String s = "    Keine Sprungfolge gefunden - Aufgabe unl\u00f6sbar";
        if (Main.debug) {
            System.out.println(s);
        }
        bw.write(System.getProperty("line.separator"));
        bw.write(s);
    }

    private void ausgabe(BufferedWriter bw, boolean zustand) throws IOException {
        StringBuffer ausgabeString = new StringBuffer();
        String lineEnd = System.getProperty("line.separator");
        if (lineEnd == null) {
            lineEnd = "\n";
        }
        String tabulator = "    ";
        int y = this.matrix.getYDimension();
        int x = this.matrix.getXDimension();
        String trennzeichen = "+";
        int i = 0;
        while (i < x) {
            trennzeichen = String.valueOf(trennzeichen) + " -- +";
            ++i;
        }
        if (zustand) {
            ausgabeString.append(String.valueOf(lineEnd) + lineEnd + tabulator + "Ausgabedatei: " + lineEnd);
            ausgabeString.append(String.valueOf(tabulator) + "*************" + lineEnd);
        } else {
            ausgabeString.append(String.valueOf(lineEnd) + tabulator + "Eingabedaten: " + lineEnd);
            ausgabeString.append(String.valueOf(tabulator) + "*************" + lineEnd);
        }
        i = 0;
        while (i < y) {
            ausgabeString.append(String.valueOf(lineEnd) + tabulator);
            ausgabeString.append(trennzeichen);
            ausgabeString.append(String.valueOf(lineEnd) + tabulator);
            int j = 0;
            while (j < x) {
                String zeichen = " ";
                int wert = this.matrix.getWert(i, j);
                switch (wert) {
                    case -1: {
                        zeichen = "X";
                        break;
                    }
                    case 0: {
                        zeichen = this.matrix.isStartpunkt(i, j) ? "1" : " ";
                        break;
                    }
                    case 1: {
                        zeichen = "1";
                        break;
                    }
                    default: {
                        zeichen = zustand ? "" + wert : " ";
                    }
                }
                ausgabeString.append("| " + (zeichen.length() < 2 ? " " : "") + zeichen + " ");
                ++j;
            }
            ausgabeString.append("|");
            ++i;
        }
        ausgabeString.append(String.valueOf(lineEnd) + tabulator);
        ausgabeString.append(trennzeichen);
        ausgabeString.append(lineEnd);
        if (Main.debug) {
            System.out.println(ausgabeString);
        }
        bw.write(ausgabeString.toString());
    }
}

