/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.BufferedWriter;
import java.io.IOException;
import main.NoInputException;
import main.WrongParameterException;
import main.ausgabe.Ausgabe;
import main.ausgabe.FehlerAusgabe;
import main.eingabe.Eingabe;
import main.tools.file.OutputFile;
import main.verarbeitung.Matrix;
import main.verarbeitung.Verarbeitung;

public class Main {
    public static final int maxDimension = 6;
    public static boolean debug = false;
    public static boolean overwrite = false;
    public static Matrix matrix = new Matrix();

    public static void main(String[] args) {
        String dateiName = null;
        BufferedWriter bw = null;
        try {
            try {
                dateiName = Main.parameterParser(args);
                bw = new OutputFile(dateiName, ".out").getAusgabeDatei();
                new Eingabe(matrix, dateiName);
                new Verarbeitung(matrix);
                new Ausgabe(matrix, bw);
            }
            catch (Exception e) {
                new FehlerAusgabe(bw, e, dateiName);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                System.err.println("Ausgabedatei konnte nicht geschrieben werden.");
            }
            throw throwable;
        }
        Object var4_6 = null;
        try {
            if (bw != null) {
                bw.close();
            }
        }
        catch (IOException e) {
            System.err.println("Ausgabedatei konnte nicht geschrieben werden.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String parameterParser(String[] parameter) throws WrongParameterException, NoInputException {
        String dateiName = null;
        boolean hilfe = false;
        if (parameter.length == 0) {
            throw new NoInputException();
        }
        int i = 0;
        while (i < parameter.length) {
            if (parameter[i].equalsIgnoreCase("-d")) {
                if (dateiName != null) throw new WrongParameterException("Doppelter Parameter - Dateiname schon angegeben");
                if (i >= parameter.length - 1) {
                    throw new WrongParameterException("Falscher Parameter - Dateiname fehlt");
                }
                dateiName = parameter[++i];
                if (dateiName.startsWith("-")) {
                    throw new WrongParameterException("Falscher Parameter - Dateiname fehlt");
                }
            } else if (parameter[i].equalsIgnoreCase("-debug")) {
                if (debug) throw new WrongParameterException("Doppelter Parameter -debug");
                debug = true;
            } else if (parameter[i].equalsIgnoreCase("-overwrite")) {
                if (overwrite) throw new WrongParameterException("Doppelter Parameter -overwrite");
                overwrite = true;
            } else {
                if (!parameter[i].equalsIgnoreCase("-h")) throw new WrongParameterException("Fehlerhafter Parameter - " + parameter[i]);
                if (hilfe) throw new WrongParameterException("Doppelter Parameter -h");
                hilfe = true;
            }
            ++i;
        }
        if (hilfe) {
            throw new WrongParameterException("");
        }
        if (dateiName != null) return dateiName;
        throw new WrongParameterException("Falscher Aufruf - keine Eingabedatei angegeben");
    }
}

